// CoWatch Firebase Messaging Service Worker
// This handles background push notifications
importScripts('https://www.gstatic.com/firebasejs/9.22.0/firebase-app-compat.js');
importScripts('https://www.gstatic.com/firebasejs/9.22.0/firebase-messaging-compat.js');

// Firebase configuration - these are public keys
const firebaseConfig = {
  apiKey: "AIzaSyCoWatch_YOUR_API_KEY",
  authDomain: "cowatch-app.firebaseapp.com",
  projectId: "cowatch-app",
  storageBucket: "cowatch-app.appspot.com",
  messagingSenderId: "YOUR_SENDER_ID",
  appId: "YOUR_APP_ID"
};

// Initialize Firebase
firebase.initializeApp(firebaseConfig);

// Initialize Firebase Cloud Messaging
const messaging = firebase.messaging();

// Handle background messages
messaging.onBackgroundMessage((payload) => {
  console.log('[firebase-messaging-sw.js] Received background message:', payload);
  
  const notificationTitle = payload.notification?.title || payload.data?.title || 'CoWatch';
  const notificationOptions = {
    body: payload.notification?.body || payload.data?.body || '',
    icon: '/icons/icon128.png',
    badge: '/icons/icon48.png',
    tag: payload.data?.tag || 'cowatch-notification',
    data: payload.data || {},
    actions: []
  };
  
  // Add actions based on notification type
  if (payload.data?.type === 'party_invite') {
    notificationOptions.actions = [
      { action: 'join', title: 'Join Party' },
      { action: 'dismiss', title: 'Dismiss' }
    ];
    notificationOptions.requireInteraction = true;
  } else if (payload.data?.type === 'friend_request') {
    notificationOptions.actions = [
      { action: 'accept', title: 'Accept' },
      { action: 'decline', title: 'Decline' }
    ];
  }
  
  return self.registration.showNotification(notificationTitle, notificationOptions);
});

// Handle notification clicks
self.addEventListener('notificationclick', (event) => {
  console.log('[firebase-messaging-sw.js] Notification clicked:', event);
  
  event.notification.close();
  
  const data = event.notification.data || {};
  let url = 'https://cowatch.app';
  
  // Handle different actions
  if (event.action === 'join' && data.roomCode) {
    url = `https://cowatch.app/join/${data.roomCode}`;
  } else if (event.action === 'accept' && data.friendId) {
    url = `https://cowatch.app/friends?accept=${data.friendId}`;
  } else if (data.url) {
    url = data.url;
  }
  
  // Open or focus the appropriate window
  event.waitUntil(
    clients.matchAll({ type: 'window', includeUncontrolled: true })
      .then((windowClients) => {
        // Check if there's already a window open
        for (const client of windowClients) {
          if (client.url.includes('cowatch.app') && 'focus' in client) {
            client.postMessage({
              type: 'NOTIFICATION_CLICK',
              data: data
            });
            return client.focus();
          }
        }
        // Open new window if none found
        if (clients.openWindow) {
          return clients.openWindow(url);
        }
      })
  );
});

// Handle push subscription changes
self.addEventListener('pushsubscriptionchange', (event) => {
  console.log('[firebase-messaging-sw.js] Push subscription changed');
  
  event.waitUntil(
    self.registration.pushManager.subscribe({
      userVisibleOnly: true,
      applicationServerKey: firebaseConfig.vapidKey
    })
    .then((subscription) => {
      // Send new subscription to server
      return fetch('https://cowatch.app/api/notifications/subscribe', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(subscription)
      });
    })
  );
});

console.log('[firebase-messaging-sw.js] Service worker loaded');
