// CoWatch Extension - Internationalization (i18n)
// Multi-language support for the extension popup

const SUPPORTED_LANGUAGES = ['en', 'tr', 'es', 'de', 'fr', 'it', 'pt', 'ru', 'ja', 'ko', 'zh', 'ar', 'hi', 'nl', 'pl', 'sv'];

const translations = {
  en: {
    // Header
    'guest': 'Guest',
    'signIn': 'Sign in',
    'signInWithGoogle': 'Sign in with Google',
    // Platform Selection
    'platformIntro': 'To use the extension, please select one of the following services below.',
    'supportedServices': 'Supported Services',
    'freeServices': 'Free services',
    'premiumServices': 'Premium Services',
    // Signup
    'signUpTitle': 'Sign Up For CoWatch',
    'signUpSubtitle': 'Welcome to CoWatch! Please sign in to start watching with friends.',
    'signUp': 'Sign Up',
    'continueAsGuest': 'Continue as Guest',
    // Party Settings
    'createParty': 'Create a CoWatch Party',
    'partySettings': 'Party Settings',
    'onlyIControl': 'Only I have control',
    'disableReactions': 'Disable Reactions For Party',
    'startTheParty': 'Start the party',
    'joinExistingParty': 'Join existing party',
    'partyNote': 'Please make sure to tell your guests that they need to click on the red',
    'partyNote2': 'icon to join a party after clicking on your party invite link.',
    // Party Active
    'showChatSidebar': 'Show Chat Sidebar',
    'shareText': 'Share the URL below so others can join the party. The recipient(s) should navigate to this URL and then click on the red CoWatch icon to join.',
    'disconnect': 'Disconnect',
    // Join Room
    'joinParty': 'Join a CoWatch Party',
    'enterRoomCode': 'Enter room code',
    'joinPartyBtn': 'Join Party',
    'back': '← Back',
    // Join Room (old keys for compatibility)
    'joinRoom': 'Join a Room',
    'roomCodePlaceholder': 'Enter room code (e.g., ABC123)',
    'joinBtn': 'Join Room',
    'or': 'or',
    // Create Room
    'createRoom': 'Create a New Room',
    'roomNamePlaceholder': 'Room name (e.g., Movie Night)',
    'createBtn': 'Create Room',
    // Friends
    'friends': 'Friends',
    'online': 'Online',
    'offline': 'Offline',
    'allFriends': 'All Friends',
    'add': 'Add',
    'noFriendsOnline': 'No friends online',
    'noFriendsYet': 'No friends yet. Add some!',
    'noFriends': 'No friends yet',
    'addFriendsHint': 'Add friends to watch together',
    'friendEmailPlaceholder': 'Enter friend\'s email',
    'searchFriend': 'Username or email',
    'sendFriendRequest': 'Send Friend Request',
    'requestSent': 'Request Sent!',
    'friendRequestSent': 'Friend request sent!',
    'friendAdded': 'Friend added!',
    'enterUsernameOrEmail': 'Enter username or email',
    'invite': 'Invite',
    'sent': 'Sent!',
    'inviteLinkCopied': 'Invite link copied!',
    'startPartyFirst': 'Start a party first to invite friends',
    // Notifications
    'notifications': 'Notifications',
    'noNotifications': 'No notifications',
    'clearAll': 'Clear all',
    'sentFriendRequest': 'sent you a friend request',
    'accept': 'Accept',
    'decline': 'Decline',
    'friendRequestAccepted': 'Friend request accepted!',
    'friendRequestDeclined': 'Friend request declined',
    'startingSoon': 'is starting soon!',
    'justNow': 'just now',
    'ago': 'ago',
    // Schedule
    'schedule': 'Schedule',
    'scheduleParty': 'Schedule a Party',
    'noScheduledParties': 'No scheduled parties',
    'partyTitle': 'Party Title',
    'partyTitlePlaceholder': 'Movie Night',
    'platform': 'Platform',
    'platforms': 'Platforms',
    'contentUrl': 'Content URL (optional)',
    'date': 'Date',
    'time': 'Time',
    'inviteFriends': 'Invite Friends',
    'cancel': 'Cancel',
    'partyScheduled': 'Party scheduled!',
    'enterPartyTitle': 'Enter a party title',
    'selectDateTime': 'Select date and time',
    'selectFutureTime': 'Select a future time',
    'invited': 'invited',
    'join': 'Join',
    // Guest Prompt
    'signInPrompt': 'Sign in to add friends and invite them directly to your watch parties!',
    'signIn': 'Sign In',
    'logout': 'Log out',
    // Status
    'notConnected': 'Not connected to any room',
    'connected': 'Connected',
    'videoSynced': 'Video synced',
    // Connected State
    'copyInviteLink': 'Copy Invite Link',
    'copied': 'Copied!',
    'noFriendsToInvite': 'No friends online to invite',
    'leaveRoom': 'Leave Room',
    // Footer
    'openCoWatch': 'Open CoWatch.app',
    // Language
    'language': 'Language',
    'selectLanguage': 'Select Language',
  },
  tr: {
    'guest': 'Misafir',
    'signIn': 'Giriş yap',
    'signInWithGoogle': 'Google ile giriş yap',
    // Platform Selection
    'platformIntro': 'Eklentiyi kullanmak için aşağıdaki hizmetlerden birini seçin.',
    'supportedServices': 'Desteklenen Hizmetler',
    'freeServices': 'Ücretsiz hizmetler',
    'premiumServices': 'Premium Hizmetler',
    // Signup
    'signUpTitle': 'CoWatch\'a Kaydol',
    'signUpSubtitle': 'CoWatch\'a hoş geldiniz! Arkadaşlarınızla izlemeye başlamak için giriş yapın.',
    'signUp': 'Kaydol',
    'continueAsGuest': 'Misafir olarak devam et',
    // Party Settings
    'createParty': 'CoWatch Partisi Oluştur',
    'partySettings': 'Parti Ayarları',
    'onlyIControl': 'Sadece ben kontrol edeyim',
    'disableReactions': 'Parti için tepkileri kapat',
    'startTheParty': 'Partiyi başlat',
    'joinExistingParty': 'Mevcut partiye katıl',
    'partyNote': 'Misafirlerinize, parti davet linkinize tıkladıktan sonra kırmızı',
    'partyNote2': 'simgesine tıklamaları gerektiğini söylemeyi unutmayın.',
    // Party Active
    'showChatSidebar': 'Sohbet Panelini Göster',
    'shareText': 'Aşağıdaki URL\'yi paylaşarak diğerlerinin partiye katılmasını sağlayın. Alıcılar bu URL\'ye gidip kırmızı CoWatch simgesine tıklamalıdır.',
    'disconnect': 'Bağlantıyı Kes',
    // Join Room
    'joinParty': 'CoWatch Partisine Katıl',
    'enterRoomCode': 'Oda kodunu girin',
    'joinPartyBtn': 'Partiye Katıl',
    'back': '← Geri',
    // Old keys
    'joinRoom': 'Odaya Katıl',
    'roomCodePlaceholder': 'Oda kodu girin (ör: ABC123)',
    'joinBtn': 'Odaya Katıl',
    'or': 'veya',
    'createRoom': 'Yeni Oda Oluştur',
    'roomNamePlaceholder': 'Oda adı (ör: Film Gecesi)',
    'createBtn': 'Oda Oluştur',
    'friends': 'Arkadaşlar',
    'online': 'Çevrimiçi',
    'offline': 'Çevrimdışı',
    'allFriends': 'Tüm Arkadaşlar',
    'add': 'Ekle',
    'noFriendsOnline': 'Çevrimiçi arkadaş yok',
    'noFriendsYet': 'Henüz arkadaş yok. Ekleyin!',
    'noFriends': 'Henüz arkadaş yok',
    'addFriendsHint': 'Birlikte izlemek için arkadaş ekleyin',
    'friendEmailPlaceholder': 'Arkadaşınızın e-postası',
    'searchFriend': 'Kullanıcı adı veya e-posta',
    'sendFriendRequest': 'Arkadaşlık İsteği Gönder',
    'requestSent': 'İstek Gönderildi!',
    'friendRequestSent': 'Arkadaşlık isteği gönderildi!',
    'friendAdded': 'Arkadaş eklendi!',
    'enterUsernameOrEmail': 'Kullanıcı adı veya e-posta girin',
    'invite': 'Davet Et',
    'sent': 'Gönderildi!',
    'inviteLinkCopied': 'Davet linki kopyalandı!',
    'startPartyFirst': 'Arkadaşları davet etmek için önce parti başlatın',
    // Notifications
    'notifications': 'Bildirimler',
    'noNotifications': 'Bildirim yok',
    'clearAll': 'Tümünü temizle',
    'sentFriendRequest': 'size arkadaşlık isteği gönderdi',
    'accept': 'Kabul Et',
    'decline': 'Reddet',
    'friendRequestAccepted': 'Arkadaşlık isteği kabul edildi!',
    'friendRequestDeclined': 'Arkadaşlık isteği reddedildi',
    'startingSoon': 'yakında başlıyor!',
    'justNow': 'şimdi',
    'ago': 'önce',
    // Schedule
    'schedule': 'Program',
    'scheduleParty': 'Parti Planla',
    'noScheduledParties': 'Planlanmış parti yok',
    'partyTitle': 'Parti Başlığı',
    'partyTitlePlaceholder': 'Film Gecesi',
    'platform': 'Platform',
    'platforms': 'Platformlar',
    'contentUrl': 'İçerik URL\'si (opsiyonel)',
    'date': 'Tarih',
    'time': 'Saat',
    'inviteFriends': 'Arkadaşları Davet Et',
    'cancel': 'İptal',
    'partyScheduled': 'Parti planlandı!',
    'enterPartyTitle': 'Parti başlığı girin',
    'selectDateTime': 'Tarih ve saat seçin',
    'selectFutureTime': 'Gelecek bir zaman seçin',
    'invited': 'davetli',
    'join': 'Katıl',
    // Other
    'signInPrompt': 'Arkadaş eklemek ve onları izleme partilerinize davet etmek için giriş yapın!',
    'logout': 'Çıkış Yap',
    'notConnected': 'Herhangi bir odaya bağlı değil',
    'connected': 'Bağlandı',
    'videoSynced': 'Video senkronize',
    'copyInviteLink': 'Davet Linkini Kopyala',
    'copied': 'Kopyalandı!',
    'noFriendsToInvite': 'Davet edilecek çevrimiçi arkadaş yok',
    'leaveRoom': 'Odadan Ayrıl',
    'openCoWatch': 'CoWatch.app\'i Aç',
    'language': 'Dil',
    'selectLanguage': 'Dil Seçin',
  },
  es: {
    'guest': 'Invitado',
    'joinRoom': 'Unirse a una Sala',
    'roomCodePlaceholder': 'Ingresa el código (ej: ABC123)',
    'joinBtn': 'Unirse',
    'or': 'o',
    'createRoom': 'Crear Nueva Sala',
    'roomNamePlaceholder': 'Nombre de sala (ej: Noche de Película)',
    'createBtn': 'Crear Sala',
    'friends': 'Amigos',
    'online': 'En línea',
    'allFriends': 'Todos',
    'add': 'Agregar',
    'noFriendsOnline': 'No hay amigos en línea',
    'noFriendsYet': 'Sin amigos aún. ¡Agrega algunos!',
    'friendEmailPlaceholder': 'Email de tu amigo',
    'sendFriendRequest': 'Enviar Solicitud',
    'requestSent': '¡Solicitud Enviada!',
    'invite': 'Invitar',
    'sent': '¡Enviado!',
    'signInPrompt': '¡Inicia sesión para agregar amigos e invitarlos a tus fiestas!',
    'signIn': 'Iniciar Sesión',
    'notConnected': 'No conectado a ninguna sala',
    'connected': 'Conectado',
    'videoSynced': 'Video sincronizado',
    'copyInviteLink': 'Copiar Enlace',
    'copied': '¡Copiado!',
    'inviteFriends': 'Invitar Amigos',
    'noFriendsToInvite': 'No hay amigos para invitar',
    'leaveRoom': 'Salir de la Sala',
    'openCoWatch': 'Abrir CoWatch.app',
    'language': 'Idioma',
    'selectLanguage': 'Seleccionar Idioma',
  },
  de: {
    'guest': 'Gast',
    'joinRoom': 'Raum Beitreten',
    'roomCodePlaceholder': 'Raumcode eingeben (z.B. ABC123)',
    'joinBtn': 'Beitreten',
    'or': 'oder',
    'createRoom': 'Neuen Raum Erstellen',
    'roomNamePlaceholder': 'Raumname (z.B. Filmabend)',
    'createBtn': 'Raum Erstellen',
    'friends': 'Freunde',
    'online': 'Online',
    'allFriends': 'Alle',
    'add': 'Hinzufügen',
    'noFriendsOnline': 'Keine Freunde online',
    'noFriendsYet': 'Noch keine Freunde. Füge welche hinzu!',
    'friendEmailPlaceholder': 'E-Mail des Freundes',
    'sendFriendRequest': 'Anfrage Senden',
    'requestSent': 'Anfrage Gesendet!',
    'invite': 'Einladen',
    'sent': 'Gesendet!',
    'signInPrompt': 'Melde dich an, um Freunde einzuladen!',
    'signIn': 'Anmelden',
    'notConnected': 'Mit keinem Raum verbunden',
    'connected': 'Verbunden',
    'videoSynced': 'Video synchronisiert',
    'copyInviteLink': 'Link Kopieren',
    'copied': 'Kopiert!',
    'inviteFriends': 'Freunde Einladen',
    'noFriendsToInvite': 'Keine Freunde zum Einladen online',
    'leaveRoom': 'Raum Verlassen',
    'openCoWatch': 'CoWatch.app Öffnen',
    'language': 'Sprache',
    'selectLanguage': 'Sprache Auswählen',
  },
  fr: {
    'guest': 'Invité',
    'joinRoom': 'Rejoindre une Salle',
    'roomCodePlaceholder': 'Entrez le code (ex: ABC123)',
    'joinBtn': 'Rejoindre',
    'or': 'ou',
    'createRoom': 'Créer une Salle',
    'roomNamePlaceholder': 'Nom de salle (ex: Soirée Film)',
    'createBtn': 'Créer',
    'friends': 'Amis',
    'online': 'En ligne',
    'allFriends': 'Tous',
    'add': 'Ajouter',
    'noFriendsOnline': 'Aucun ami en ligne',
    'noFriendsYet': 'Pas encore d\'amis. Ajoutez-en!',
    'friendEmailPlaceholder': 'Email de l\'ami',
    'sendFriendRequest': 'Envoyer Demande',
    'requestSent': 'Demande Envoyée!',
    'invite': 'Inviter',
    'sent': 'Envoyé!',
    'signInPrompt': 'Connectez-vous pour inviter des amis!',
    'signIn': 'Connexion',
    'notConnected': 'Non connecté',
    'connected': 'Connecté',
    'videoSynced': 'Vidéo synchronisée',
    'copyInviteLink': 'Copier le Lien',
    'copied': 'Copié!',
    'inviteFriends': 'Inviter des Amis',
    'noFriendsToInvite': 'Aucun ami à inviter',
    'leaveRoom': 'Quitter la Salle',
    'openCoWatch': 'Ouvrir CoWatch.app',
    'language': 'Langue',
    'selectLanguage': 'Choisir la Langue',
  },
  it: {
    'guest': 'Ospite',
    'joinRoom': 'Entra in una Stanza',
    'roomCodePlaceholder': 'Inserisci il codice (es: ABC123)',
    'joinBtn': 'Entra',
    'or': 'o',
    'createRoom': 'Crea Nuova Stanza',
    'roomNamePlaceholder': 'Nome stanza (es: Serata Film)',
    'createBtn': 'Crea Stanza',
    'friends': 'Amici',
    'online': 'Online',
    'allFriends': 'Tutti',
    'add': 'Aggiungi',
    'noFriendsOnline': 'Nessun amico online',
    'noFriendsYet': 'Nessun amico ancora. Aggiungine!',
    'friendEmailPlaceholder': 'Email dell\'amico',
    'sendFriendRequest': 'Invia Richiesta',
    'requestSent': 'Richiesta Inviata!',
    'invite': 'Invita',
    'sent': 'Inviato!',
    'signInPrompt': 'Accedi per invitare amici alle tue feste!',
    'signIn': 'Accedi',
    'notConnected': 'Non connesso',
    'connected': 'Connesso',
    'videoSynced': 'Video sincronizzato',
    'copyInviteLink': 'Copia Link',
    'copied': 'Copiato!',
    'inviteFriends': 'Invita Amici',
    'noFriendsToInvite': 'Nessun amico da invitare',
    'leaveRoom': 'Esci dalla Stanza',
    'openCoWatch': 'Apri CoWatch.app',
    'language': 'Lingua',
    'selectLanguage': 'Seleziona Lingua',
  },
  pt: {
    'guest': 'Convidado',
    'joinRoom': 'Entrar em uma Sala',
    'roomCodePlaceholder': 'Digite o código (ex: ABC123)',
    'joinBtn': 'Entrar',
    'or': 'ou',
    'createRoom': 'Criar Nova Sala',
    'roomNamePlaceholder': 'Nome da sala (ex: Noite de Filme)',
    'createBtn': 'Criar Sala',
    'friends': 'Amigos',
    'online': 'Online',
    'allFriends': 'Todos',
    'add': 'Adicionar',
    'noFriendsOnline': 'Nenhum amigo online',
    'noFriendsYet': 'Sem amigos ainda. Adicione!',
    'friendEmailPlaceholder': 'Email do amigo',
    'sendFriendRequest': 'Enviar Pedido',
    'requestSent': 'Pedido Enviado!',
    'invite': 'Convidar',
    'sent': 'Enviado!',
    'signInPrompt': 'Entre para convidar amigos para suas festas!',
    'signIn': 'Entrar',
    'notConnected': 'Não conectado',
    'connected': 'Conectado',
    'videoSynced': 'Vídeo sincronizado',
    'copyInviteLink': 'Copiar Link',
    'copied': 'Copiado!',
    'inviteFriends': 'Convidar Amigos',
    'noFriendsToInvite': 'Nenhum amigo para convidar',
    'leaveRoom': 'Sair da Sala',
    'openCoWatch': 'Abrir CoWatch.app',
    'language': 'Idioma',
    'selectLanguage': 'Selecionar Idioma',
  },
  ru: {
    'guest': 'Гость',
    'joinRoom': 'Войти в Комнату',
    'roomCodePlaceholder': 'Введите код (напр: ABC123)',
    'joinBtn': 'Войти',
    'or': 'или',
    'createRoom': 'Создать Комнату',
    'roomNamePlaceholder': 'Название (напр: Киновечер)',
    'createBtn': 'Создать',
    'friends': 'Друзья',
    'online': 'Онлайн',
    'allFriends': 'Все',
    'add': 'Добавить',
    'noFriendsOnline': 'Нет друзей онлайн',
    'noFriendsYet': 'Пока нет друзей. Добавьте!',
    'friendEmailPlaceholder': 'Email друга',
    'sendFriendRequest': 'Отправить Запрос',
    'requestSent': 'Запрос Отправлен!',
    'invite': 'Пригласить',
    'sent': 'Отправлено!',
    'signInPrompt': 'Войдите, чтобы приглашать друзей!',
    'signIn': 'Войти',
    'notConnected': 'Не подключено',
    'connected': 'Подключено',
    'videoSynced': 'Видео синхронизировано',
    'copyInviteLink': 'Копировать Ссылку',
    'copied': 'Скопировано!',
    'inviteFriends': 'Пригласить Друзей',
    'noFriendsToInvite': 'Нет друзей для приглашения',
    'leaveRoom': 'Покинуть Комнату',
    'openCoWatch': 'Открыть CoWatch.app',
    'language': 'Язык',
    'selectLanguage': 'Выбрать Язык',
  },
  ja: {
    'guest': 'ゲスト',
    'joinRoom': 'ルームに参加',
    'roomCodePlaceholder': 'コードを入力 (例: ABC123)',
    'joinBtn': '参加',
    'or': 'または',
    'createRoom': '新しいルームを作成',
    'roomNamePlaceholder': 'ルーム名 (例: 映画の夜)',
    'createBtn': '作成',
    'friends': '友達',
    'online': 'オンライン',
    'allFriends': '全員',
    'add': '追加',
    'noFriendsOnline': 'オンラインの友達なし',
    'noFriendsYet': 'まだ友達がいません。追加しよう！',
    'friendEmailPlaceholder': '友達のメール',
    'sendFriendRequest': 'リクエスト送信',
    'requestSent': '送信済み！',
    'invite': '招待',
    'sent': '送信！',
    'signInPrompt': 'ログインして友達を招待しよう！',
    'signIn': 'ログイン',
    'notConnected': '未接続',
    'connected': '接続済み',
    'videoSynced': '動画同期済み',
    'copyInviteLink': 'リンクをコピー',
    'copied': 'コピー済み！',
    'inviteFriends': '友達を招待',
    'noFriendsToInvite': '招待できる友達がいません',
    'leaveRoom': 'ルームを退出',
    'openCoWatch': 'CoWatch.appを開く',
    'language': '言語',
    'selectLanguage': '言語を選択',
  },
  ko: {
    'guest': '게스트',
    'joinRoom': '방 참가',
    'roomCodePlaceholder': '코드 입력 (예: ABC123)',
    'joinBtn': '참가',
    'or': '또는',
    'createRoom': '새 방 만들기',
    'roomNamePlaceholder': '방 이름 (예: 영화의 밤)',
    'createBtn': '만들기',
    'friends': '친구',
    'online': '온라인',
    'allFriends': '전체',
    'add': '추가',
    'noFriendsOnline': '온라인 친구 없음',
    'noFriendsYet': '아직 친구가 없어요. 추가하세요!',
    'friendEmailPlaceholder': '친구 이메일',
    'sendFriendRequest': '요청 보내기',
    'requestSent': '요청 완료!',
    'invite': '초대',
    'sent': '전송됨!',
    'signInPrompt': '로그인하여 친구를 초대하세요!',
    'signIn': '로그인',
    'notConnected': '연결 안됨',
    'connected': '연결됨',
    'videoSynced': '영상 동기화됨',
    'copyInviteLink': '링크 복사',
    'copied': '복사됨!',
    'inviteFriends': '친구 초대',
    'noFriendsToInvite': '초대할 친구 없음',
    'leaveRoom': '방 나가기',
    'openCoWatch': 'CoWatch.app 열기',
    'language': '언어',
    'selectLanguage': '언어 선택',
  },
  zh: {
    'guest': '访客',
    'joinRoom': '加入房间',
    'roomCodePlaceholder': '输入房间代码 (例: ABC123)',
    'joinBtn': '加入',
    'or': '或',
    'createRoom': '创建新房间',
    'roomNamePlaceholder': '房间名 (例: 电影之夜)',
    'createBtn': '创建',
    'friends': '好友',
    'online': '在线',
    'allFriends': '全部',
    'add': '添加',
    'noFriendsOnline': '没有好友在线',
    'noFriendsYet': '还没有好友。添加一些吧！',
    'friendEmailPlaceholder': '好友邮箱',
    'sendFriendRequest': '发送请求',
    'requestSent': '请求已发送！',
    'invite': '邀请',
    'sent': '已发送！',
    'signInPrompt': '登录后邀请好友参加派对！',
    'signIn': '登录',
    'notConnected': '未连接',
    'connected': '已连接',
    'videoSynced': '视频已同步',
    'copyInviteLink': '复制链接',
    'copied': '已复制！',
    'inviteFriends': '邀请好友',
    'noFriendsToInvite': '没有可邀请的好友',
    'leaveRoom': '离开房间',
    'openCoWatch': '打开 CoWatch.app',
    'language': '语言',
    'selectLanguage': '选择语言',
  },
  ar: {
    'guest': 'ضيف',
    'joinRoom': 'انضم إلى غرفة',
    'roomCodePlaceholder': 'أدخل الرمز (مثال: ABC123)',
    'joinBtn': 'انضمام',
    'or': 'أو',
    'createRoom': 'إنشاء غرفة جديدة',
    'roomNamePlaceholder': 'اسم الغرفة (مثال: ليلة فيلم)',
    'createBtn': 'إنشاء',
    'friends': 'الأصدقاء',
    'online': 'متصل',
    'allFriends': 'الكل',
    'add': 'إضافة',
    'noFriendsOnline': 'لا أصدقاء متصلين',
    'noFriendsYet': 'لا أصدقاء بعد. أضف بعضهم!',
    'friendEmailPlaceholder': 'بريد الصديق',
    'sendFriendRequest': 'إرسال طلب',
    'requestSent': 'تم الإرسال!',
    'invite': 'دعوة',
    'sent': 'أُرسل!',
    'signInPrompt': 'سجل دخولك لدعوة الأصدقاء!',
    'signIn': 'تسجيل الدخول',
    'notConnected': 'غير متصل',
    'connected': 'متصل',
    'videoSynced': 'الفيديو متزامن',
    'copyInviteLink': 'نسخ الرابط',
    'copied': 'تم النسخ!',
    'inviteFriends': 'دعوة الأصدقاء',
    'noFriendsToInvite': 'لا أصدقاء للدعوة',
    'leaveRoom': 'مغادرة الغرفة',
    'openCoWatch': 'افتح CoWatch.app',
    'language': 'اللغة',
    'selectLanguage': 'اختر اللغة',
  },
  hi: {
    'guest': 'अतिथि',
    'joinRoom': 'रूम में शामिल हों',
    'roomCodePlaceholder': 'कोड दर्ज करें (जैसे: ABC123)',
    'joinBtn': 'शामिल हों',
    'or': 'या',
    'createRoom': 'नया रूम बनाएं',
    'roomNamePlaceholder': 'रूम का नाम (जैसे: मूवी नाइट)',
    'createBtn': 'बनाएं',
    'friends': 'दोस्त',
    'online': 'ऑनलाइन',
    'allFriends': 'सभी',
    'add': 'जोड़ें',
    'noFriendsOnline': 'कोई दोस्त ऑनलाइन नहीं',
    'noFriendsYet': 'अभी तक कोई दोस्त नहीं। जोड़ें!',
    'friendEmailPlaceholder': 'दोस्त का ईमेल',
    'sendFriendRequest': 'अनुरोध भेजें',
    'requestSent': 'अनुरोध भेजा गया!',
    'invite': 'आमंत्रित करें',
    'sent': 'भेजा!',
    'signInPrompt': 'दोस्तों को आमंत्रित करने के लिए साइन इन करें!',
    'signIn': 'साइन इन',
    'notConnected': 'कनेक्ट नहीं',
    'connected': 'कनेक्टेड',
    'videoSynced': 'वीडियो सिंक्ड',
    'copyInviteLink': 'लिंक कॉपी करें',
    'copied': 'कॉपी हो गया!',
    'inviteFriends': 'दोस्तों को आमंत्रित करें',
    'noFriendsToInvite': 'आमंत्रित करने के लिए कोई दोस्त नहीं',
    'leaveRoom': 'रूम छोड़ें',
    'openCoWatch': 'CoWatch.app खोलें',
    'language': 'भाषा',
    'selectLanguage': 'भाषा चुनें',
  },
  nl: {
    'guest': 'Gast',
    'joinRoom': 'Kamer Betreden',
    'roomCodePlaceholder': 'Voer code in (bijv: ABC123)',
    'joinBtn': 'Betreden',
    'or': 'of',
    'createRoom': 'Nieuwe Kamer Maken',
    'roomNamePlaceholder': 'Kamernaam (bijv: Filmavond)',
    'createBtn': 'Maken',
    'friends': 'Vrienden',
    'online': 'Online',
    'allFriends': 'Allemaal',
    'add': 'Toevoegen',
    'noFriendsOnline': 'Geen vrienden online',
    'noFriendsYet': 'Nog geen vrienden. Voeg toe!',
    'friendEmailPlaceholder': 'Email van vriend',
    'sendFriendRequest': 'Verzoek Sturen',
    'requestSent': 'Verzoek Verstuurd!',
    'invite': 'Uitnodigen',
    'sent': 'Verstuurd!',
    'signInPrompt': 'Log in om vrienden uit te nodigen!',
    'signIn': 'Inloggen',
    'notConnected': 'Niet verbonden',
    'connected': 'Verbonden',
    'videoSynced': 'Video gesynchroniseerd',
    'copyInviteLink': 'Link Kopiëren',
    'copied': 'Gekopieerd!',
    'inviteFriends': 'Vrienden Uitnodigen',
    'noFriendsToInvite': 'Geen vrienden om uit te nodigen',
    'leaveRoom': 'Kamer Verlaten',
    'openCoWatch': 'CoWatch.app Openen',
    'language': 'Taal',
    'selectLanguage': 'Taal Selecteren',
  },
  pl: {
    'guest': 'Gość',
    'joinRoom': 'Dołącz do Pokoju',
    'roomCodePlaceholder': 'Wpisz kod (np: ABC123)',
    'joinBtn': 'Dołącz',
    'or': 'lub',
    'createRoom': 'Utwórz Nowy Pokój',
    'roomNamePlaceholder': 'Nazwa pokoju (np: Wieczór Filmowy)',
    'createBtn': 'Utwórz',
    'friends': 'Znajomi',
    'online': 'Online',
    'allFriends': 'Wszyscy',
    'add': 'Dodaj',
    'noFriendsOnline': 'Brak znajomych online',
    'noFriendsYet': 'Brak znajomych. Dodaj!',
    'friendEmailPlaceholder': 'Email znajomego',
    'sendFriendRequest': 'Wyślij Zaproszenie',
    'requestSent': 'Zaproszenie Wysłane!',
    'invite': 'Zaproś',
    'sent': 'Wysłano!',
    'signInPrompt': 'Zaloguj się, aby zapraszać znajomych!',
    'signIn': 'Zaloguj',
    'notConnected': 'Nie połączono',
    'connected': 'Połączono',
    'videoSynced': 'Wideo zsynchronizowane',
    'copyInviteLink': 'Kopiuj Link',
    'copied': 'Skopiowano!',
    'inviteFriends': 'Zaproś Znajomych',
    'noFriendsToInvite': 'Brak znajomych do zaproszenia',
    'leaveRoom': 'Opuść Pokój',
    'openCoWatch': 'Otwórz CoWatch.app',
    'language': 'Język',
    'selectLanguage': 'Wybierz Język',
  },
  sv: {
    'guest': 'Gäst',
    'joinRoom': 'Gå med i Rum',
    'roomCodePlaceholder': 'Ange kod (ex: ABC123)',
    'joinBtn': 'Gå med',
    'or': 'eller',
    'createRoom': 'Skapa Nytt Rum',
    'roomNamePlaceholder': 'Rumsnamn (ex: Filmkväll)',
    'createBtn': 'Skapa',
    'friends': 'Vänner',
    'online': 'Online',
    'allFriends': 'Alla',
    'add': 'Lägg till',
    'noFriendsOnline': 'Inga vänner online',
    'noFriendsYet': 'Inga vänner än. Lägg till!',
    'friendEmailPlaceholder': 'Väns e-post',
    'sendFriendRequest': 'Skicka Förfrågan',
    'requestSent': 'Förfrågan Skickad!',
    'invite': 'Bjud in',
    'sent': 'Skickat!',
    'signInPrompt': 'Logga in för att bjuda in vänner!',
    'signIn': 'Logga in',
    'notConnected': 'Ej ansluten',
    'connected': 'Ansluten',
    'videoSynced': 'Video synkroniserad',
    'copyInviteLink': 'Kopiera Länk',
    'copied': 'Kopierat!',
    'inviteFriends': 'Bjud in Vänner',
    'noFriendsToInvite': 'Inga vänner att bjuda in',
    'leaveRoom': 'Lämna Rum',
    'openCoWatch': 'Öppna CoWatch.app',
    'language': 'Språk',
    'selectLanguage': 'Välj Språk',
  },
};

// Language names for the selector
const languageNames = {
  en: 'English',
  tr: 'Türkçe',
  es: 'Español',
  de: 'Deutsch',
  fr: 'Français',
  it: 'Italiano',
  pt: 'Português',
  ru: 'Русский',
  ja: '日本語',
  ko: '한국어',
  zh: '中文',
  ar: 'العربية',
  hi: 'हिन्दी',
  nl: 'Nederlands',
  pl: 'Polski',
  sv: 'Svenska',
};

// Current language
let currentLanguage = 'en';

// Get translation
function t(key) {
  return translations[currentLanguage]?.[key] || translations.en[key] || key;
}

// Get current language
function getCurrentLanguage() {
  return currentLanguage;
}

// Update all translations in the DOM
function updateAllTranslations() {
  console.log('🌐 Updating translations to:', currentLanguage);
  
  // Update elements with data-i18n attribute
  document.querySelectorAll('[data-i18n]').forEach(el => {
    const key = el.getAttribute('data-i18n');
    const translation = t(key);
    if (translation) {
      el.textContent = translation;
    }
  });
  
  // Update elements with data-i18n-placeholder attribute
  document.querySelectorAll('[data-i18n-placeholder]').forEach(el => {
    const key = el.getAttribute('data-i18n-placeholder');
    const translation = t(key);
    if (translation) {
      el.placeholder = translation;
    }
  });
  
  console.log('🌐 Translations updated');
}

// Set language
async function setLanguage(lang) {
  if (SUPPORTED_LANGUAGES.includes(lang)) {
    currentLanguage = lang;
    // Save to storage
    if (typeof chrome !== 'undefined' && chrome.storage) {
      await chrome.storage.local.set({ language: lang });
    }
    return true;
  }
  return false;
}

// Load saved language
async function loadSavedLanguage() {
  try {
    if (typeof chrome !== 'undefined' && chrome.storage) {
      const result = await chrome.storage.local.get(['language']);
      if (result.language && SUPPORTED_LANGUAGES.includes(result.language)) {
        currentLanguage = result.language;
        return currentLanguage;
      }
    }
  } catch (e) {
    console.error('Failed to load language:', e);
  }
  
  // Try to detect browser language
  const browserLang = navigator.language?.split('-')[0];
  if (browserLang && SUPPORTED_LANGUAGES.includes(browserLang)) {
    currentLanguage = browserLang;
  }
  
  return currentLanguage;
}

// Export for use
if (typeof module !== 'undefined' && module.exports) {
  module.exports = { t, getCurrentLanguage, setLanguage, loadSavedLanguage, languageNames, SUPPORTED_LANGUAGES };
}
