// CoWatch Crave Injected Script (Canadian streaming)
// This script runs in the PAGE CONTEXT to access Crave's internal data
// Based on Teleparty's proven approach - intercepts XHR for episode info
(function() {
  'use strict';

  // Prevent double initialization
  if (window.cowatchCraveLoaded) return;
  window.cowatchCraveLoaded = true;

  console.log('🎬 CoWatch Crave: Injected script loaded');

  // ============== SYNC CONSTANTS ==============
  const SYNC_THRESHOLD_SECONDS = 2;
  const SEEK_OFFSET_MS = 100;

  // ============== URL PATTERNS ==============
  const CONTENTS_RE = /^https:\/\/playback\.rte-api\.bellmedia\.ca\/contents\/([^/?#]+)/i;
  const EPISODES_RE = /^https:\/\/playback\.rte-api\.bellmedia\.ca\/seasons\/([^/]+)\/episodes/i;
  const UP_NEXT_RE = /^https:\/\/playback\.rte-api\.bellmedia\.ca\/contents\/([^/?#]+)\/up-next-content/i;

  // ============== EPISODE DATA ==============
  let currentContentId = null;
  let currentEpisodeData = null;

  // ============== XHR INTERCEPTION ==============
  function interceptXHR() {
    const originalOpen = XMLHttpRequest.prototype.open;
    const originalSend = XMLHttpRequest.prototype.send;

    XMLHttpRequest.prototype.open = function(method, url, ...args) {
      this._cowatchUrl = url;
      return originalOpen.apply(this, [method, url, ...args]);
    };

    XMLHttpRequest.prototype.send = function(...args) {
      this.addEventListener('load', function() {
        try {
          const url = this._cowatchUrl;
          
          // Capture content ID
          const contentsMatch = url.match(CONTENTS_RE);
          if (contentsMatch) {
            currentContentId = contentsMatch[1];
          }

          // Capture episode data
          const episodesMatch = url.match(EPISODES_RE);
          if (episodesMatch && this.responseText) {
            const data = JSON.parse(this.responseText);
            if (data.episodes) {
              currentEpisodeData = data.episodes;
            }
          }

          // Capture up-next content
          const upNextMatch = url.match(UP_NEXT_RE);
          if (upNextMatch && this.responseText) {
            const data = JSON.parse(this.responseText);
            dispatchToContent({
              type: 'cowatch:upNext',
              data: data
            });
          }
        } catch (e) {
          // Ignore parse errors
        }
      });

      return originalSend.apply(this, args);
    };
  }

  // ============== DISPATCH TO CONTENT ==============
  function dispatchToContent(detail) {
    const evt = new CustomEvent('FromNode', { detail });
    window.dispatchEvent(evt);
  }

  // ============== MESSAGE HANDLER ==============
  window.addEventListener('message', function(e) {
    if (e.source !== window) return;
    
    const type = e.data?.type;
    if (!type) return;

    switch (type) {
      case 'cowatch:getState': {
        const video = document.querySelector('video');
        if (video) {
          dispatchToContent({
            type: 'cowatch:state',
            time: video.currentTime * 1000,
            paused: video.paused,
            duration: video.duration * 1000,
            contentId: currentContentId
          });
        }
        break;
      }

      case 'cowatch:getEpisodeData': {
        dispatchToContent({
          type: 'cowatch:episodeData',
          data: currentEpisodeData
        });
        break;
      }

      case 'cowatch:play': {
        const video = document.querySelector('video');
        if (video) video.play();
        break;
      }

      case 'cowatch:pause': {
        const video = document.querySelector('video');
        if (video) video.pause();
        break;
      }

      case 'cowatch:seek': {
        const video = document.querySelector('video');
        if (video) {
          const offsetTime = Math.max(0, e.data.time - SEEK_OFFSET_MS);
          video.currentTime = offsetTime / 1000;
        }
        break;
      }
    }
  });

  // ============== VIDEO EVENT LISTENERS ==============
  function setupVideoListeners() {
    const video = document.querySelector('video');
    if (!video) {
      setTimeout(setupVideoListeners, 500);
      return;
    }

    video.addEventListener('play', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'play' });
    });

    video.addEventListener('pause', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'pause' });
    });

    video.addEventListener('seeked', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'seek' });
    });

    video.addEventListener('waiting', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: true });
    });

    video.addEventListener('playing', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: false });
    });
  }

  // ============== INITIALIZATION ==============
  function init() {
    console.log('🎬 CoWatch Crave: Initializing...');
    interceptXHR();
    setupVideoListeners();
    console.log('🎬 CoWatch Crave: Initialization complete');
  }

  init();
})();
