// CoWatch Hotstar Injected Script
// This script runs in the PAGE CONTEXT to access Hotstar's internal API
// Based on Teleparty's proven approach - for India/APAC region
(function() {
  'use strict';

  // Prevent double initialization
  if (window.cowatchHotstarLoaded) return;
  window.cowatchHotstarLoaded = true;

  console.log('🎬 CoWatch Hotstar: Injected script loaded');

  // ============== SYNC CONSTANTS ==============
  const SYNC_THRESHOLD_SECONDS = 2;
  const SEEK_OFFSET_MS = 100;

  // ============== DISPATCH TO CONTENT ==============
  function dispatchToContent(detail) {
    const evt = new CustomEvent('FromNode', { detail });
    window.dispatchEvent(evt);
  }

  // ============== MESSAGE HANDLER ==============
  window.addEventListener('message', function(e) {
    if (e.source !== window) return;
    
    const type = e.data?.type;
    if (!type) return;

    switch (type) {
      case 'cowatch:getState': {
        const video = document.querySelector('video');
        if (video) {
          dispatchToContent({
            type: 'cowatch:state',
            time: video.currentTime * 1000,
            paused: video.paused,
            duration: video.duration * 1000
          });
        }
        break;
      }

      case 'cowatch:play': {
        const video = document.querySelector('video');
        if (video) video.play();
        break;
      }

      case 'cowatch:pause': {
        const video = document.querySelector('video');
        if (video) video.pause();
        break;
      }

      case 'cowatch:seek': {
        const video = document.querySelector('video');
        if (video) {
          const offsetTime = Math.max(0, e.data.time - SEEK_OFFSET_MS);
          video.currentTime = offsetTime / 1000;
        }
        break;
      }
    }
  });

  // ============== VIDEO EVENT LISTENERS ==============
  function setupVideoListeners() {
    const video = document.querySelector('video');
    if (!video) {
      setTimeout(setupVideoListeners, 500);
      return;
    }

    video.addEventListener('play', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'play' });
    });

    video.addEventListener('pause', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'pause' });
    });

    video.addEventListener('seeked', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'seek' });
    });

    video.addEventListener('waiting', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: true });
    });

    video.addEventListener('playing', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: false });
    });
  }

  // ============== INITIALIZATION ==============
  function init() {
    console.log('🎬 CoWatch Hotstar: Initializing...');
    setupVideoListeners();
    console.log('🎬 CoWatch Hotstar: Initialization complete');
  }

  init();
})();
