// CoWatch Paramount+ Injected Script
// This script runs in the PAGE CONTEXT to access Paramount+'s internal API
// Based on Teleparty's proven approach
(function() {
  'use strict';

  // Prevent double initialization
  if (window.cowatchParamountLoaded) return;
  window.cowatchParamountLoaded = true;

  console.log('🎬 CoWatch Paramount+: Injected script loaded');

  // ============== SYNC CONSTANTS ==============
  const SYNC_THRESHOLD_SECONDS = 2;
  const SEEK_OFFSET_MS = 100;

  // ============== PLAYBACK STATE ==============
  const PlaybackState = {
    LOADING: 'loading',
    PLAYING: 'playing',
    IDLE: 'idle',
    AD_PLAYING: 'ad_playing',
    PAUSED: 'paused',
    NOT_READY: 'not_ready'
  };

  // ============== REACT INTERNAL ACCESS ==============
  function getReactFiber(root) {
    if (!root) return null;
    const keys = Object.keys(root);
    for (let i = 0; i < keys.length; i++) {
      if (keys[i].startsWith('__reactFiber') || keys[i].startsWith('__reactInternalInstance')) {
        return root[keys[i]];
      }
    }
    return null;
  }

  // ============== VIDEO FUNCTIONS ==============
  function getVideo() {
    return document.querySelector('video');
  }

  function getPlaybackState() {
    const video = getVideo();
    if (!video) return PlaybackState.NOT_READY;
    
    // Check for ad indicators
    const adIndicator = document.querySelector('[class*="ad-"]') || 
                       document.querySelector('[data-testid*="ad"]');
    if (adIndicator) return PlaybackState.AD_PLAYING;
    
    if (video.readyState < 3) return PlaybackState.LOADING;
    if (video.paused) return PlaybackState.PAUSED;
    return PlaybackState.PLAYING;
  }

  // ============== DISPATCH TO CONTENT ==============
  function dispatchToContent(detail) {
    const evt = new CustomEvent('FromNode', { detail });
    window.dispatchEvent(evt);
  }

  // ============== MESSAGE HANDLER ==============
  window.addEventListener('message', function(e) {
    if (e.source !== window) return;
    
    const type = e.data?.type;
    if (!type) return;

    switch (type) {
      case 'cowatch:getState': {
        const video = getVideo();
        if (video) {
          dispatchToContent({
            type: 'cowatch:state',
            time: video.currentTime * 1000,
            paused: video.paused,
            duration: video.duration * 1000,
            playbackState: getPlaybackState()
          });
        }
        break;
      }

      case 'cowatch:play': {
        const video = getVideo();
        if (video) video.play();
        break;
      }

      case 'cowatch:pause': {
        const video = getVideo();
        if (video) video.pause();
        break;
      }

      case 'cowatch:seek': {
        const video = getVideo();
        if (video) {
          const offsetTime = Math.max(0, e.data.time - SEEK_OFFSET_MS);
          video.currentTime = offsetTime / 1000;
        }
        break;
      }
    }
  });

  // ============== VIDEO EVENT LISTENERS ==============
  function setupVideoListeners() {
    const video = getVideo();
    if (!video) {
      setTimeout(setupVideoListeners, 500);
      return;
    }

    video.addEventListener('play', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'play' });
    });

    video.addEventListener('pause', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'pause' });
    });

    video.addEventListener('seeked', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'seek' });
    });

    video.addEventListener('waiting', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: true });
    });

    video.addEventListener('playing', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: false });
    });

    video.addEventListener('timeupdate', () => {
      // Periodic state update
    });
  }

  // ============== INITIALIZATION ==============
  function init() {
    console.log('🎬 CoWatch Paramount+: Initializing...');
    setupVideoListeners();
    console.log('🎬 CoWatch Paramount+: Initialization complete');
  }

  init();
})();
