// CoWatch Pluto TV Injected Script
// This script runs in the PAGE CONTEXT to access Pluto's internal data
// Based on Teleparty's proven approach - includes ad break capture
(function() {
  'use strict';

  // Prevent double initialization
  if (window.cowatchPlutoLoaded) return;
  window.cowatchPlutoLoaded = true;

  console.log('🎬 CoWatch Pluto TV: Injected script loaded');

  // ============== SYNC CONSTANTS ==============
  const SYNC_THRESHOLD_SECONDS = 2;
  const SEEK_OFFSET_MS = 100;

  // ============== AD BREAK STORAGE ==============
  let adBreakLocations = [];

  // ============== INTERCEPT FETCH FOR AD BREAKS ==============
  function interceptFetch() {
    const originalFetch = window.fetch;
    window.fetch = async (...args) => {
      const response = await originalFetch(...args);
      
      try {
        const url = args[0]?.url || args[0];
        // Capture ad break locations from Pluto API
        if (url && url.includes('api.pluto.tv') && url.includes('clips')) {
          const clone = response.clone();
          const data = await clone.json();
          if (data.adBreaks) {
            adBreakLocations = data.adBreaks;
            storeAdBreakLocations(adBreakLocations);
          }
        }
      } catch (e) {
        // Ignore errors
      }
      
      return response;
    };
  }

  // Store ad break locations in DOM for content script access
  function storeAdBreakLocations(locations) {
    let container = document.querySelector('#cowatch-ad-break-locations');
    if (!container) {
      container = document.createElement('div');
      container.id = 'cowatch-ad-break-locations';
      container.style.display = 'none';
      document.body.appendChild(container);
    }
    container.setAttribute('data-ad-break-locations', JSON.stringify(locations));
  }

  // ============== DISPATCH TO CONTENT ==============
  function dispatchToContent(detail) {
    const evt = new CustomEvent('FromNode', { detail });
    window.dispatchEvent(evt);
  }

  // ============== MESSAGE HANDLER ==============
  window.addEventListener('message', function(e) {
    if (e.source !== window) return;
    
    const type = e.data?.type;
    if (!type) return;

    switch (type) {
      case 'cowatch:getState': {
        const video = document.querySelector('video');
        if (video) {
          dispatchToContent({
            type: 'cowatch:state',
            time: video.currentTime * 1000,
            paused: video.paused,
            duration: video.duration * 1000,
            adBreaks: adBreakLocations
          });
        }
        break;
      }

      case 'cowatch:getAdBreaks': {
        dispatchToContent({
          type: 'cowatch:adBreaks',
          data: adBreakLocations
        });
        break;
      }

      case 'cowatch:play': {
        const video = document.querySelector('video');
        if (video) video.play();
        break;
      }

      case 'cowatch:pause': {
        const video = document.querySelector('video');
        if (video) video.pause();
        break;
      }

      case 'cowatch:seek': {
        const video = document.querySelector('video');
        if (video) {
          const offsetTime = Math.max(0, e.data.time - SEEK_OFFSET_MS);
          video.currentTime = offsetTime / 1000;
        }
        break;
      }
    }
  });

  // ============== VIDEO EVENT LISTENERS ==============
  function setupVideoListeners() {
    const video = document.querySelector('video');
    if (!video) {
      setTimeout(setupVideoListeners, 500);
      return;
    }

    video.addEventListener('play', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'play' });
    });

    video.addEventListener('pause', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'pause' });
    });

    video.addEventListener('seeked', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'seek' });
    });

    video.addEventListener('waiting', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: true });
    });

    video.addEventListener('playing', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: false });
    });
  }

  // ============== INITIALIZATION ==============
  function init() {
    console.log('🎬 CoWatch Pluto TV: Initializing...');
    interceptFetch();
    setupVideoListeners();
    console.log('🎬 CoWatch Pluto TV: Initialization complete');
  }

  init();
})();
