// CoWatch Star+ Injected Script
// Based on Teleparty's approach - Star+ uses same structure as Disney+
(function() {
  'use strict';

  if (window.cowatchStarplusLoaded) return;
  window.cowatchStarplusLoaded = true;

  console.log('⭐ CoWatch Star+: Injected script loaded');

  // ============== REACT INTERNAL ACCESS ==============
  
  function getReactInternals(element) {
    if (!element) return null;
    const keys = Object.keys(element);
    for (const key of keys) {
      if (key.startsWith('__reactInternalInstance')) {
        return element[key];
      }
    }
    return null;
  }

  // ============== REACT PROPS ==============

  function findReactProps() {
    try {
      const elementRoot = document.querySelector("main#section_index > div");
      if (!elementRoot) return null;

      const internals = getReactInternals(elementRoot);
      if (!internals) return null;

      if (internals.memoizedProps?.children?._owner?.memoizedProps) {
        return internals.memoizedProps.children._owner.memoizedProps;
      }
      return null;
    } catch (e) {
      return null;
    }
  }

  // ============== VIDEO ELEMENT ==============

  function getVideo() {
    return document.querySelector('video');
  }

  // ============== NAVIGATE TO VIDEO ==============

  function navigateToVideo(videoId) {
    const reactProps = findReactProps();
    if (reactProps?.navigate) {
      reactProps.navigate({
        name: 'video',
        params: {
          contentId: videoId,
          timerAutoAdvanced: true
        }
      });
    }
  }

  // ============== MESSAGE HANDLER ==============

  function handleMessage(event) {
    if (event.source !== window) return;
    
    const { type, time, videoId } = event.data;
    if (!type) return;

    console.log('⭐ CoWatch Star+: Message received:', type);

    switch (type) {
      case 'COWATCH_GET_STATE': {
        const video = getVideo();
        
        if (video) {
          window.dispatchEvent(new CustomEvent('COWATCH_STATE', {
            detail: {
              currentTime: video.currentTime * 1000,
              duration: video.duration * 1000,
              paused: video.paused,
              playbackRate: video.playbackRate,
              platform: 'starplus'
            }
          }));
        }
        break;
      }

      case 'COWATCH_SEEK': {
        const video = getVideo();
        if (video && time !== undefined) {
          video.currentTime = time / 1000;
        }
        break;
      }

      case 'COWATCH_PLAY': {
        const video = getVideo();
        if (video) video.play();
        break;
      }

      case 'COWATCH_PAUSE': {
        const video = getVideo();
        if (video) video.pause();
        break;
      }

      case 'COWATCH_NEXT_EPISODE': {
        if (videoId) {
          navigateToVideo(videoId);
        }
        break;
      }

      case 'COWATCH_TEARDOWN': {
        window.removeEventListener('message', handleMessage);
        window.cowatchStarplusLoaded = false;
        break;
      }
    }
  }

  // ============== INITIALIZATION ==============

  window.addEventListener('message', handleMessage);

  // Notify content script that injected script is ready
  window.postMessage({ type: 'COWATCH_INJECTED_READY', platform: 'starplus' }, '*');
})();
