// CoWatch Tubi TV Injected Script
// This script runs in the PAGE CONTEXT to access Tubi's internal data
// Based on Teleparty's proven approach
(function() {
  'use strict';

  // Prevent double initialization
  if (window.cowatchTubiLoaded) return;
  window.cowatchTubiLoaded = true;

  console.log('🎬 CoWatch Tubi: Injected script loaded');

  // ============== SYNC CONSTANTS ==============
  const SYNC_THRESHOLD_SECONDS = 2;
  const SEEK_OFFSET_MS = 100;

  // ============== VIDEO LOOKUP DATA ==============
  function getVideoLookupData() {
    let title;
    const titleEl = document.querySelector('.web-poster__image-element');
    if (titleEl) {
      title = titleEl.getAttribute('alt');
    }

    // Check for next episode button to determine if TV show
    const nextEl = document.querySelector('.atvwebplayersdk-nexttitle-button');
    const type = nextEl ? 'TV' : 'MOVIE';

    let releaseYear;
    const yearEl = document.querySelector('.web-attributes__year-duration');
    if (yearEl) {
      releaseYear = yearEl.textContent.split(' ')[0];
    }

    return { title, type, releaseYear };
  }

  // ============== DISPATCH TO CONTENT ==============
  function dispatchToContent(detail) {
    const evt = new CustomEvent('FromNode', { detail });
    window.dispatchEvent(evt);
  }

  // ============== MESSAGE HANDLER ==============
  window.addEventListener('TubiTvVideoMessage', function(evt) {
    const type = evt.detail?.type;
    
    if (type === 'getVideoLookupData') {
      const data = getVideoLookupData();
      dispatchToContent({
        type: 'GetLookupData',
        data: data
      });
    }
  });

  // Generic CoWatch message handler
  window.addEventListener('message', function(e) {
    if (e.source !== window) return;
    
    const type = e.data?.type;
    if (!type) return;

    switch (type) {
      case 'cowatch:getState': {
        const video = document.querySelector('video');
        if (video) {
          dispatchToContent({
            type: 'cowatch:state',
            time: video.currentTime * 1000,
            paused: video.paused,
            duration: video.duration * 1000
          });
        }
        break;
      }

      case 'cowatch:play': {
        const video = document.querySelector('video');
        if (video) video.play();
        break;
      }

      case 'cowatch:pause': {
        const video = document.querySelector('video');
        if (video) video.pause();
        break;
      }

      case 'cowatch:seek': {
        const video = document.querySelector('video');
        if (video) {
          const offsetTime = Math.max(0, e.data.time - SEEK_OFFSET_MS);
          video.currentTime = offsetTime / 1000;
        }
        break;
      }

      case 'cowatch:getMetadata': {
        dispatchToContent({
          type: 'cowatch:metadata',
          data: getVideoLookupData()
        });
        break;
      }
    }
  });

  // ============== VIDEO EVENT LISTENERS ==============
  function setupVideoListeners() {
    const video = document.querySelector('video');
    if (!video) {
      setTimeout(setupVideoListeners, 500);
      return;
    }

    video.addEventListener('play', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'play' });
    });

    video.addEventListener('pause', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'pause' });
    });

    video.addEventListener('seeked', () => {
      dispatchToContent({ type: 'cowatch:userInteraction', action: 'seek' });
    });

    video.addEventListener('waiting', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: true });
    });

    video.addEventListener('playing', () => {
      dispatchToContent({ type: 'cowatch:buffering', isBuffering: false });
    });
  }

  // ============== INITIALIZATION ==============
  function init() {
    console.log('🎬 CoWatch Tubi: Initializing...');
    setupVideoListeners();
    console.log('🎬 CoWatch Tubi: Initialization complete');
  }

  init();
})();
