// CoWatch U-Next Injected Script
// Standard video element approach for Japanese streaming
(function() {
  'use strict';

  if (window.cowatchUnextLoaded) return;
  window.cowatchUnextLoaded = true;

  console.log('🇯🇵 CoWatch U-Next: Injected script loaded');

  // ============== VIDEO ELEMENT ==============

  function getVideo() {
    return document.querySelector('video');
  }

  // ============== MESSAGE HANDLER ==============

  function handleMessage(event) {
    if (event.source !== window) return;
    
    const { type, time } = event.data;
    if (!type) return;

    console.log('🇯🇵 CoWatch U-Next: Message received:', type);

    switch (type) {
      case 'COWATCH_GET_STATE': {
        const video = getVideo();
        
        if (video) {
          window.dispatchEvent(new CustomEvent('COWATCH_STATE', {
            detail: {
              currentTime: video.currentTime * 1000,
              duration: video.duration * 1000,
              paused: video.paused,
              playbackRate: video.playbackRate,
              platform: 'unext'
            }
          }));
        }
        break;
      }

      case 'COWATCH_SEEK': {
        const video = getVideo();
        if (video && time !== undefined) {
          video.currentTime = time / 1000;
        }
        break;
      }

      case 'COWATCH_PLAY': {
        const video = getVideo();
        if (video) video.play();
        break;
      }

      case 'COWATCH_PAUSE': {
        const video = getVideo();
        if (video) video.pause();
        break;
      }

      case 'COWATCH_TEARDOWN': {
        window.removeEventListener('message', handleMessage);
        window.cowatchUnextLoaded = false;
        break;
      }
    }
  }

  // ============== INITIALIZATION ==============

  window.addEventListener('message', handleMessage);

  // Notify content script that injected script is ready
  window.postMessage({ type: 'COWATCH_INJECTED_READY', platform: 'unext' }, '*');
})();
