// CoWatch Vidio Injected Script
// Based on Teleparty's approach - Next.js router navigation
(function() {
  'use strict';

  if (window.cowatchVidioLoaded) return;
  window.cowatchVidioLoaded = true;

  console.log('📺 CoWatch Vidio: Injected script loaded');

  // ============== VIDEO ELEMENT ==============

  function getVideo() {
    return document.querySelector('video');
  }

  // ============== NAVIGATION ==============

  function navigateTo(url) {
    try {
      if (window.next?.router?.push) {
        window.next.router.push(url);
      } else {
        window.location.href = url;
      }
    } catch (e) {
      console.warn('CoWatch Vidio: Navigation error:', e);
      window.location.href = url;
    }
  }

  // ============== MESSAGE HANDLER ==============

  function handleMessage(event) {
    if (event.source !== window) return;
    
    const { type, time, url } = event.data;
    if (!type) return;

    console.log('📺 CoWatch Vidio: Message received:', type);

    switch (type) {
      case 'COWATCH_GET_STATE': {
        const video = getVideo();
        
        if (video) {
          window.dispatchEvent(new CustomEvent('COWATCH_STATE', {
            detail: {
              currentTime: video.currentTime * 1000,
              duration: video.duration * 1000,
              paused: video.paused,
              playbackRate: video.playbackRate,
              platform: 'vidio'
            }
          }));
        }
        break;
      }

      case 'COWATCH_SEEK': {
        const video = getVideo();
        if (video && time !== undefined) {
          video.currentTime = time / 1000;
        }
        break;
      }

      case 'COWATCH_PLAY': {
        const video = getVideo();
        if (video) video.play();
        break;
      }

      case 'COWATCH_PAUSE': {
        const video = getVideo();
        if (video) video.pause();
        break;
      }

      case 'COWATCH_NAVIGATE':
      case 'VIDIO_NAVIGATE': {
        if (url) {
          navigateTo(url);
        }
        break;
      }

      case 'COWATCH_TEARDOWN': {
        window.removeEventListener('message', handleMessage);
        window.cowatchVidioLoaded = false;
        break;
      }
    }
  }

  // ============== INITIALIZATION ==============

  window.addEventListener('message', handleMessage);

  // Notify content script that injected script is ready
  window.postMessage({ type: 'COWATCH_INJECTED_READY', platform: 'vidio' }, '*');
})();
